// To parse this JSON data, do
//
//     final updateInvoiceResponseModel = updateInvoiceResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:viserpay_merchant/data/model/invoice/invoice_history_response_model.dart';

import '../auth/login/login_response_model.dart';

UpdateInvoiceResponseModel updateInvoiceResponseModelFromJson(String str) => UpdateInvoiceResponseModel.fromJson(json.decode(str));

String updateInvoiceResponseModelToJson(UpdateInvoiceResponseModel data) => json.encode(data.toJson());

class UpdateInvoiceResponseModel {
    String? remark;
    String? status;
    Message? message;
    Data? data;

    UpdateInvoiceResponseModel({
        this.remark,
        this.status,
        this.message,
        this.data,
    });

    factory UpdateInvoiceResponseModel.fromJson(Map<String, dynamic> json) => UpdateInvoiceResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
    );

    Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
    };
}

class Data {
    InvoiceDataModel? invoice;

    Data({
        this.invoice,
    });

    factory Data.fromJson(Map<String, dynamic> json) => Data(
        invoice: json["invoice"] == null ? null : InvoiceDataModel.fromJson(json["invoice"]),
    );

    Map<String, dynamic> toJson() => {
        "invoice": invoice?.toJson(),
    };
}
